/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.block.BufferBlockTier;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntityContents;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BufferBlockEntity
extends BlockEntity {
    private final BufferBlockEntityContents contents;

    public BufferBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(SFMBlockEntities.BUFFER_BLOCK_ENTITY.get(), pPos, pBlockState);
        BufferBlockTier bufferBlockTier;
        Block block = pBlockState.getBlock();
        if (block instanceof BufferBlock) {
            BufferBlock bufferBlock = (BufferBlock)block;
            bufferBlockTier = bufferBlock.tier;
        } else {
            bufferBlockTier = BufferBlockTier.Unit;
        }
        BufferBlockTier tier = bufferBlockTier;
        this.contents = new BufferBlockEntityContents(tier);
    }

    public BufferBlockEntityContents getContents() {
        return this.contents;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BufferBlockEntity bufferBlockEntity) {
        if (bufferBlockEntity.getContents().lastUsedResource != state.getValue(BufferBlock.CONTAINED_RESOURCE)) {
            level.setBlock(pos, (BlockState)state.setValue(BufferBlock.CONTAINED_RESOURCE, (Comparable)((Object)bufferBlockEntity.getContents().lastUsedResource)), 2);
        }
    }
}

